package ru.yandex.crypta.idm;

public final class LocalizedString {

    private final String ru;
    private final String en;

    private LocalizedString(String ru, String en) {
        this.ru = ru;
        this.en = en;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String ru;
        private String en;

        private Builder() {
        }

        public Builder ru(String ru) {
            this.ru = ru;
            return this;
        }

        public Builder en(String en) {
            this.en = en;
            return this;
        }

        public LocalizedString build() {
            return new LocalizedString(ru, en);
        }
    }

    public String getRu() {
        return ru;
    }

    public String getEn() {
        return en;
    }
}
