package ru.yandex.crypta.idm;

import ru.yandex.misc.lang.DefaultObject;

public class Role extends DefaultObject {

    private String group;
    private String subgroup;
    private String subsubgroup;

    private static RoleBuilder builder() {
        return new RoleBuilder();
    }

    public Role() {
    }

    public Role(String group, String subgroup, String subsubgroup) {
        this.group = group;
        this.subgroup = subgroup;
        this.subsubgroup = subsubgroup;
    }

    public String getGroup() {
        return group;
    }

    public String getSubgroup() {
        return subgroup;
    }

    public String getSubsubgroup() {
        return subsubgroup;
    }

    public static RoleBuilder fromUnderscoreString(String roleName) {
        String[] parts = roleName.split("_", -1);
        if (parts.length == 1) {
            return Role.builder().group(parts[0]);
        } else if (parts.length == 2) {
            return Role.builder().group(parts[0]).subgroup(parts[1]);
        } else if (parts.length == 3) {
            return Role.builder().group(parts[0]).subgroup(parts[1]).subsubgroup(parts[2]);
        } else {
            throw new RuntimeException("Invalid role name " + roleName);
        }
    }

    public static class RoleBuilder {

        private String group;
        private String subgroup;
        private String subsubgroup;

        public RoleBuilder group(String group) {
            this.group = group;
            return this;
        }

        public RoleBuilder subgroup(String subgroup) {
            this.subgroup = subgroup;
            return this;
        }

        public RoleBuilder subsubgroup(String subsubgroup) {
            this.subsubgroup = subsubgroup;
            return this;
        }


        public Role build() {
            return new Role(group, subgroup, subsubgroup);
        }
    }
}
