package ru.yandex.crypta.idm.bin;

import io.swagger.models.Swagger;
import org.glassfish.jersey.internal.inject.AbstractBinder;

import ru.yandex.crypta.common.ws.AbstractServer;
import ru.yandex.crypta.common.ws.DefaultWsApplication;
import ru.yandex.crypta.config.ApiSwagger;
import ru.yandex.crypta.config.CommandLine;
import ru.yandex.crypta.config.Initialization;
import ru.yandex.crypta.idm.config.DependencyInjection;
import ru.yandex.crypta.idm.proto.TApiServerConfig;
import ru.yandex.crypta.idm.rest.RestRoot;

public class Main extends DefaultWsApplication {

    protected TApiServerConfig config;
    protected AbstractServer server;
    private static final String API_TITLE = "Crypta IDM API";
    private static final String API_DESCRIPTION = "Provides IDM integration with Crypta";

    protected Main(String[] args) {
        TApiServerConfig config = (TApiServerConfig) CommandLine.parseArgs(TApiServerConfig.newBuilder(), args);
        this.config = updateConfig(config);
        this.server = createServer();
    }

    public static void main(String[] args) {
        Initialization.run(Main.class);
        new Main(args).run();
    }

    protected TApiServerConfig updateConfig(TApiServerConfig config) {
        return config;
    }

    private void run() {
        startServer();
    }

    public void startServer() {
        server.start();
    }

    @Override
    protected String getPrefix() {
        return config.getHttp().getPrefix();
    }

    @Override
    protected int getPort() {
        return config.getHttp().getPort();
    }

    @Override
    protected void bindCustom(AbstractBinder binder) {
        DependencyInjection.bind(config, binder);
    }

    @Override
    protected Class<?> getRestRootClass() {
        return RestRoot.class;
    }

    @Override
    protected Swagger getSwagger() {
        return ApiSwagger.process(Main.class, API_TITLE, API_DESCRIPTION, createSwagger());
    }

}
