package ru.yandex.crypta.idm.config;

import javax.inject.Singleton;

import org.glassfish.jersey.internal.inject.AbstractBinder;

import ru.yandex.crypta.clients.blackbox.BlackboxClient;
import ru.yandex.crypta.clients.blackbox.HttpBlackboxClient;
import ru.yandex.crypta.clients.blackbox.NoAuthHttpBlackboxClient;
import ru.yandex.crypta.clients.idm.JooqRoleService;
import ru.yandex.crypta.clients.idm.RoleService;
import ru.yandex.crypta.clients.pgaas.HikariPostgresClient;
import ru.yandex.crypta.clients.pgaas.PostgresClient;
import ru.yandex.crypta.clients.tvm.DefaultTvmClient;
import ru.yandex.crypta.clients.tvm.IDefaultTvmClient;
import ru.yandex.crypta.clients.tvm.StubTvmClient;
import ru.yandex.crypta.clients.tvm.TvmClient;
import ru.yandex.crypta.clients.tvm.TvmClientIcebergImpl;
import ru.yandex.crypta.common.ws.config.ConfigUtils;
import ru.yandex.crypta.idm.migrations.Migrations;
import ru.yandex.crypta.idm.proto.TApiServerConfig;

public class DependencyInjection {

    private DependencyInjection() {
    }

    public static void bind(TApiServerConfig config, AbstractBinder binder) {
        bindConfig(config, binder);
        bindTvm(config, binder);
        bindAuth(config, binder);

        binder.bindAsContract(Migrations.class).in(Singleton.class);
        binder.bind(HikariPostgresClient.class).to(PostgresClient.class).in(Singleton.class);
        binder.bind(JooqRoleService.class).to(RoleService.class).in(Singleton.class);
    }

    private static void bindTvm(TApiServerConfig config, AbstractBinder binder) {
        if (config.getDevelopment().getDisableTvm()) {
            binder.bind(StubTvmClient.class).to(TvmClient.class).in(Singleton.class);
        } else {
            binder.bind(TvmClientIcebergImpl.class).to(TvmClient.class).in(Singleton.class);
        }

        binder.bind(DefaultTvmClient.class).to(IDefaultTvmClient.class).in(Singleton.class);
    }

    private static void bindAuth(TApiServerConfig config, AbstractBinder binder) {
        if (config.getDevelopment().getDisableAuth()) {
            binder.bind(NoAuthHttpBlackboxClient.class).to(BlackboxClient.class).in(Singleton.class);
        } else {
            binder.bind(HttpBlackboxClient.class).to(BlackboxClient.class).in(Singleton.class);
        }
    }

    private static void bindConfig(TApiServerConfig config, AbstractBinder binder) {
        binder.bind(config)
                .to(TApiServerConfig.class)
                .in(Singleton.class);

        ConfigUtils.bindFields(config, binder);
    }
}
