package ru.yandex.crypta.idm.migrations;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.flywaydb.core.Flyway;
import org.glassfish.jersey.internal.inject.InjectionManager;

import ru.yandex.crypta.clients.pgaas.PostgresClient;

@Singleton
public class Migrations {

    private final PostgresClient sql;
    private final InjectionManager injectionManager;

    @Inject
    public Migrations(PostgresClient sql, InjectionManager locator) {
        this.sql = sql;
        this.injectionManager = locator;
    }

    public Flyway getFlyway() {
        return Flyway.configure()
                .dataSource(new DataSourceWithServiceProvider(sql.getDataSource(), injectionManager::getInstance))
                .table("schema_version")
                .locations("db/migration")
                .load();
    }

}
