package ru.yandex.crypta.idm.rest.resource.idm.response;

import java.util.List;

import ru.yandex.crypta.idm.Role;

public class LoginToRoleResponse extends SimpleResponse {

    private final List<LoginWithRoles> users;

    public LoginToRoleResponse(int code, List<LoginWithRoles> users) {
        super(code, null, null, null);
        this.users = users;
    }

    public List<LoginWithRoles> getUsers() {
        return users;
    }

    public final static class LoginWithRoles {
        private final String login;
        private final List<Role> roles;

        public LoginWithRoles(String login, List<Role> roles) {
            this.login = login;
            this.roles = roles;
        }

        public String getLogin() {
            return login;
        }

        public List<Role> getRoles() {
            return roles;
        }
    }

}
