package ru.yandex.crypta.idm.rest.resource.other;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jooq.Configuration;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;

import ru.yandex.crypta.clients.pgaas.PostgresClient;
import ru.yandex.crypta.common.ws.auth.AuthNotRequired;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;

@Path("database")
@Produces(JsonUtf8.MEDIA_TYPE)
@Api(tags = "database")
public class DatabaseResource {

    private final Configuration database;

    @Inject
    public DatabaseResource(PostgresClient postgres) {
        this.database = postgres.getJooqConfiguration();
    }

    @Path("check/can_connect")
    @GET
    @AuthNotRequired
    @ApiOperation("Check database status")
    @Produces(MediaType.TEXT_PLAIN)
    public Response checkDatabase() {
        try {
            DSL.using(database).execute("SELECT 1");
            return Response.ok("OK").build();
        } catch (DataAccessException exception) {
            return Response.serverError().entity(exception.getMessage()).build();
        }
    }

}
