from __future__ import print_function

import time
import getpass
import hashlib

import requests

import library.python.resource as rs
import library.python.svn_version as svn
import library.python.oauth as lpo
from crypta.lib.python.getoptpb import ParsePbOptions

from crypta.idm.workflow.options_pb2 import TCryptaIdmOptions
from crypta.lib.proto.config.environment_pb2 import EEnvironment


IDM_API_URL = {
    EEnvironment.ENV_TESTING: 'https://idm-api.test.yandex-team.ru',
    EEnvironment.ENV_PRODUCTION: 'https://idm-api.yandex-team.ru',
}


class OAuth(requests.auth.AuthBase):

    def __init__(self, token):
        self.token = token

    def __call__(self, r):
        r.headers["Authorization"] = "OAuth " + self.token
        return r


def render_workflow(common, code):
    return """# arcadia revision {}\n# generated at {} by {}@\n{}\n{}""".format(
        svn.svn_revision(),
        int(time.time()),
        getpass.getuser(),
        common,
        code,
    )


def render_resource_file(name):
    content = rs.find(name).decode('utf-8')
    content_hash = hashlib.sha1(content.encode('utf-8')).hexdigest()
    return '# {} (SHA1 {})\n{}'.format(name, content_hash, content)


def get_workflow():
    return render_workflow(render_resource_file('/common.py'), render_resource_file('/workflow.py'))


def get_group_workflow():
    return render_workflow(render_resource_file('/common.py'), render_resource_file('/group_workflow.py'))


def get_token(args):
    if args.Token:
        return args.Token

    client_id = "c92ca88b9d664402be33802f57d76dd4"
    client_secret = "bed57130101347d88ed097a7e7e90097"
    return lpo.get_token(client_id, client_secret)


def update(url, workflow, group_workflow, token):
    response_clone = requests.post(
        url + "/api/frontend/systems/crypta/clone_workflow/",
        auth=OAuth(token),
    )
    response_clone.raise_for_status()

    workflow_id = response_clone.json()["id"]

    response_update = requests.post(
        url + "/api/frontend/workflow/{}/".format(workflow_id),
        auth=OAuth(token),
        json={
            'workflow': workflow,
            'group_workflow': group_workflow,
        },
    )
    response_update.raise_for_status()

    response_commit = requests.post(
        url + "/api/frontend/workflow/{}/commit/".format(workflow_id),
        auth=OAuth(token),
        json={'silent': True},
    )
    response_commit.raise_for_status()

    response_approve = requests.post(
        url + "/api/frontend/workflow/{}/approve/".format(workflow_id),
        auth=OAuth(token),
        json={'silent': True},
    )
    response_approve.raise_for_status()


def main():
    args = ParsePbOptions(TCryptaIdmOptions)
    update(
        url=IDM_API_URL[args.Environment],
        workflow=get_workflow(),
        group_workflow=get_group_workflow(),
        token=get_token(args),
    )
    print("OK")
