#include "edge.h"
#include "node.h"

namespace NCrypta {
    namespace NIS {
        TEdge::TEdge(TNode* node1, TNode* node2)
            : Node1(node1)
            , Node2(node2)
        {
        }

        TNode* TEdge::GetAdjacentNode(const TNode* node) const {
            if (node == Node1) {
                return Node2;
            }

            if (node == Node2) {
                return Node1;
            }

            ythrow yexception() << "Given node doesn't belong to the edge";
        }
    }
}
