#pragma once

#include "node.h"
#include "edge.h"
#include "attributes.h"
#include "id_hash.h"

#include <crypta/lib/native/crypta_id/crypta_id.h>

#include <util/generic/vector.h>
#include <util/generic/ptr.h>

namespace NCrypta {
    namespace NIS {
        class TGraph {
        public:
            using TNodes = TVector<TNode*>;
            using TEdges = TVector<TEdge*>;

            using TCryptaId = ::NCrypta::TCryptaId;

            TGraph() = default;
            TGraph(const TGraph&) = delete;
            virtual ~TGraph();

            TGraph& operator=(const TGraph&) = delete;
            TGraph(TGraph&&) = default;
            TGraph& operator=(TGraph&&) = default;

            TNode* CreateNode(const TId& id);
            TNode* CreateNode(const TString& type, const TString& value);
            TEdge* CreateEdge(size_t nodeIndex1, size_t nodeIndex2);
            TEdge* CreateEdge(TNode* node1, TNode* node2);

            TNode* GetNode(size_t nodeIndex) const;
            size_t IndexOf(const TNode* node) const;
            TNode* FindNode(const TId& id) const;
            bool HasNode(const TId& id) const;

            bool IsEmpty() const;

            const TNodes& GetNodes() const;
            const TEdges& GetEdges() const;

            const TAttributes& GetAttributes() const;
            TAttributes& GetAttributes();

            bool AreAdjacent(size_t nodeIndex1, size_t nodeIndex2) const;
            bool AreAdjacent(const TNode* node1, const TNode* node2) const;

            TCryptaId GetId() const;
            void SetId(TCryptaId id);

            void Merge(TGraph&& other);

            void Clear();

            // @brief return approximate size of memory consumption
            size_t MemoryUsage() const;

        private:
            TCryptaId Id = 0;
            TNodes Nodes;
            TEdges Edges;
            TAttributes Attributes;

            THashMap<const TNode*, size_t> NodeIndices;
            THashMap<TId, TNode*> IdNodes;
        };
    }
}
