from id cimport TId
from node cimport TNode
from edge cimport TEdge
from attributes cimport TAttributes
from util.generic.string cimport TString
from util.generic.vector cimport TVector
from libcpp cimport bool
from libc cimport stdint

ctypedef TVector[TNode*] TNodes
ctypedef TVector[TEdge*] TEdges
ctypedef stdint.uint64_t TCryptaId

cdef extern from "crypta/idserv/data/graph.h" namespace 'NCrypta::NIS':
    cdef cppclass TGraph:
        TGraph()
        TGraph(TGraph&&)

        TNode* CreateNode(const TId& id) except +
        TEdge* CreateEdge(TNode* node1, TNode* node2) except +

        TNode* GetNode(size_t nodeIndex) except +
        size_t IndexOf(const TNode* node) except +
        TNode* FindNode(const TId& id) const
        bool HasNode(const TId& id) const

        const TNodes& GetNodes() const
        const TEdges& GetEdges() const
        TAttributes& GetAttributes()

        TEdge* FindEdge(const TNode* node1, const TNode* node2) except +
        bool AreAdjacent(const TNode* node1, const TNode* node2) except +

        TCryptaId GetId() const
        void SetId(TCryptaId id)

        void Merge(TGraph&& other) except +

        void Clear()
