#include "id_serializer.h"

#include <util/string/split.h>

using namespace NCrypta::NIS;

const char TIdSerializer::DELIMITER;

TString TIdSerializer::Serialize(const TId& id) {
    return Serialize(id.Type, id.Value);
}

TId TIdSerializer::Deserialize(const TString& str) {
    TId id;
    StringSplitter(str).Split(DELIMITER).Limit(2).CollectInto(&id.Type, &id.Value);
    return id;
}
