#pragma once

#include "id.h"

#include <util/string/builder.h>

namespace NCrypta {
    namespace NIS {
        class TIdSerializer {
        public:
            static TString Serialize(const TId& id);

            template <typename TValue>
            static TString Serialize(const TString& type, const TValue& value) {
                return TStringBuilder() << type << DELIMITER << value;
            }

            static TId Deserialize(const TString& str);

        private:
            static const char DELIMITER = ':';
        };
    }
}
