#include "id_utils.h"

#include <util/random/random.h>
#include <util/string/cast.h>

namespace NCrypta {
    namespace NIS {
        bool IsCryptaId(const TString& type) {
            return type == CRYPTA_ID_TYPE;
        }

        bool IsCryptaId(const TId& id) {
            return IsCryptaId(id.Type);
        }

        bool IsUnknownId(const TString& type) {
            return type == UNKNOWN_ID_TYPE;
        }

        bool IsUnknownId(const TId& id) {
            return IsUnknownId(id.Type);
        }

        bool IsIdInGraph(const TId& id, const TGraph& graph) {
            if (IsCryptaId(id)) {
                return graph.GetId() == FromString<TGraph::TCryptaId>(id.Value);
            } else {
                return graph.HasNode(id);
            }
        }

        TGraph::TCryptaId GenerateCryptaId() {
            return RandomNumber<TGraph::TCryptaId>();
        }
    }
}
