#pragma once

#include "id.h"
#include "graph.h"

namespace NCrypta {
    namespace NIS {
        bool IsCryptaId(const TString& type);
        bool IsCryptaId(const TId& id);

        bool IsUnknownId(const TString& type);
        bool IsUnknownId(const TId& id);

        bool IsIdInGraph(const TId& id, const TGraph& graph);

        TGraph::TCryptaId GenerateCryptaId();

        const TString CRYPTA_ID_TYPE = "crypta_id";
        const TString UNKNOWN_ID_TYPE = "unknown";
    }
}
