from crypta.idserv.data.python.graph import TGraph


class TIdGenerator:
    def __init__(self, base=None):
        self.prefix = str(int(base)) + '000' if base else ''

    def __call__(self, id):
        return self.prefix + str(id)


def _fill_attrs(item_attrs, item_number, factor):
    if factor > 0 and item_number % factor == 0:
        item_attrs["size"] = "M"
        item_attrs["weight"] = "10"


def _create_graph_without_edges(size, crypta_id=0, id_generator=TIdGenerator(), attrs_factor=3):
    graph = TGraph()
    graph.SetId(int(id_generator(crypta_id)))

    graph_attrs = graph.GetAttributes()
    graph_attrs['size'] = str(size)
    graph_attrs['attrs_factor'] = str(attrs_factor)

    for i in range(size):
        node = graph.CreateNode('yandexuid', id_generator(crypta_id + i + 1))
        _fill_attrs(node.Attributes, i, attrs_factor)

    return graph


def create_complete_graph(size, crypta_id=0, id_generator=TIdGenerator(), attrs_factor=3):
    graph = _create_graph_without_edges(size, crypta_id, id_generator, attrs_factor)

    for i in range(size - 1):
        for j in range(i + 1, size):
            edge = graph.CreateEdge(graph.GetNode(i), graph.GetNode(j))
            _fill_attrs(edge.Attributes, i, attrs_factor)

    return graph


def create_linear_graph(size, crypta_id=0, id_generator=TIdGenerator(), attrs_factor=3):
    graph = _create_graph_without_edges(size, crypta_id, id_generator, attrs_factor)

    for i in range(size - 1):
        edge = graph.CreateEdge(graph.GetNode(i), graph.GetNode(i + 1))
        _fill_attrs(edge.Attributes, i, attrs_factor)

    return graph


def assert_all_nodes_are_adjacent(graph, node_from=None, node_to=None):
    node_from = node_from or 0
    node_to = node_to or len(graph.GetNodes())

    for n1 in range(node_from, node_to - 1):
        for n2 in range(n1 + 1, node_to):
            assert graph.AreAdjacent(graph.GetNode(n1), graph.GetNode(n2))
