from crypta.idserv.data.attributes cimport TAttributes as TAttributesImpl
from crypta.idserv.data.edge cimport TEdge as TEdgeImpl
from crypta.idserv.data.graph cimport TCryptaId
from crypta.idserv.data.graph cimport TEdges as TEdgesImpl
from crypta.idserv.data.graph cimport TGraph as TGraphImpl
from crypta.idserv.data.graph cimport TNodes as TNodesImpl
from crypta.idserv.data.graph_comparator cimport TGraphComparator
from crypta.idserv.data.id cimport TId as TIdImpl
from crypta.idserv.data.id_serializer cimport TIdSerializer
from crypta.idserv.data.node cimport TNode as TNodeImpl
from util.generic.string cimport TString
from cpython.object cimport Py_EQ, Py_NE, Py_LT, Py_GT, Py_LE, Py_GE


cdef extern from "<utility>" namespace "std" nogil:
    cdef TGraphImpl move(TGraphImpl)


cdef Cmp(const void* ptr1, const void* ptr2, int op):
    if op == Py_EQ:
        return ptr1 == ptr2
    elif op == Py_NE:
        return ptr1 != ptr2
    elif op == Py_LT:
        return ptr1 < ptr2
    elif op == Py_GT:
        return ptr1 > ptr2
    elif op == Py_LE:
        return ptr1 <= ptr2
    elif op == Py_GE:
        return ptr1 >= ptr2
    else:
        return NotImplemented


cdef class TAttributes:
    cdef TAttributesImpl* Impl

    @staticmethod
    cdef Create(TAttributesImpl* impl):
        wrapped = TAttributes()
        wrapped.Impl = impl
        return wrapped

    def __getitem__(self, key):
        return self.Impl[0][key]

    def __setitem__(self, key, value):
        self.Impl[0][key] = value

    def update(self, attrs):
        for key, value in attrs.ToDict().iteritems():
            self[key] = value

    def __str__(self):
        return str(self.ToDict())

    def ToDict(self):
        return self.Impl[0]

    def __nonzero__(self):
        return self.Impl != NULL

    def __richcmp__(TAttributes a, TAttributes b, int op):
        return Cmp(a.Impl, b.Impl, op)


cdef class TNode:
    cdef TNodeImpl* Impl

    @staticmethod
    cdef Create(TNodeImpl* impl):
        wrapped = TNode()
        wrapped.Impl = impl
        return wrapped

    @property
    def Id(self):
        return TId.Create(&self.Impl.Id)

    @property
    def Attributes(self):
        return TAttributes.Create(&self.Impl.Attributes)

    def __nonzero__(self):
        return self.Impl != NULL

    def __richcmp__(TNode a, TNode b, int op):
        return Cmp(a.Impl, b.Impl, op)


cdef class TEdge:
    cdef TEdgeImpl* Impl

    @staticmethod
    cdef Create(TEdgeImpl* impl):
        wrapped = TEdge()
        wrapped.Impl = impl
        return wrapped

    def GetAdjacentNode(self, TNode node):
        return TNode.Create(self.Impl.GetAdjacentNode(node.Impl))

    @property
    def Node1(self):
        return TNode.Create(self.Impl.Node1)

    @property
    def Node2(self):
        return TNode.Create(self.Impl.Node2)

    @property
    def Attributes(self):
        return TAttributes.Create(&self.Impl.Attributes)

    def __nonzero__(self):
        return self.Impl != NULL

    def __richcmp__(TEdge a, TEdge b, int op):
        return Cmp(a.Impl, b.Impl, op)


cdef class TId:
    cdef const TIdImpl* Impl

    @staticmethod
    cdef Create(const TIdImpl* impl):
        wrapped = TId()
        wrapped.Impl = impl
        return wrapped

    @property
    def Type(self):
        return self.Impl.Type

    @property
    def Value(self):
        return self.Impl.Value

    def __str__(self):
        return TIdSerializer.Serialize(self.Impl[0])

    def __nonzero__(self):
        return self.Impl != NULL

    def __richcmp__(TId a, TId b, int op):
        return Cmp(a.Impl, b.Impl, op)


cdef class TNodes:
    cdef const TNodesImpl* Impl

    @staticmethod
    cdef Create(const TNodesImpl* impl):
        wrapped = TNodes()
        wrapped.Impl = impl
        return wrapped

    def __getitem__(self, index):
        return TNode.Create(self.Impl[0][index])

    def __len__(self):
        return self.Impl.size()

    def __nonzero__(self):
        return self.Impl != NULL

    def __iter__(self):
        for i in range(0, self.Impl.size()):
            yield TNode.Create(self.Impl[0][i])


cdef class TEdges:
    cdef const TEdgesImpl* Impl

    @staticmethod
    cdef Create(const TEdgesImpl* impl):
        wrapped = TEdges()
        wrapped.Impl = impl
        return wrapped

    def __getitem__(self, index):
        return TEdge.Create(self.Impl[0][index])

    def __len__(self):
        return self.Impl.size()

    def __nonzero__(self):
        return self.Impl != NULL

    def __iter__(self):
        for i in range(0, self.Impl.size()):
            yield TEdge.Create(self.Impl[0][i])


cdef class TGraph:
    def CreateNode(self, TString type, TString value):
        return TNode.Create(self.Impl.CreateNode(TIdImpl(type, value)))

    def CreateEdge(self, TNode node1, TNode node2):
        return TEdge.Create(self.Impl.CreateEdge(node1.Impl, node2.Impl))

    def GetNode(self, size_t index):
        return TNode.Create(self.Impl.GetNode(index))

    def IndexOf(self, TNode node):
        return self.Impl.IndexOf(node.Impl)

    def FindNode(self, TString type, TString value):
        return TNode.Create(self.Impl.FindNode(TIdImpl(type, value)))

    def HasNode(self, TString type, TString value):
        return self.Impl.HasNode(TIdImpl(type, value))

    def GetNodes(self):
        return TNodes.Create(&self.Impl.GetNodes())

    def GetEdges(self):
        return TEdges.Create(&self.Impl.GetEdges())

    def GetAttributes(self):
        return TAttributes.Create(&self.Impl.GetAttributes())

    def AreAdjacent(self, TNode node1, TNode node2):
        return self.Impl.AreAdjacent(node1.Impl, node2.Impl)

    def GetId(self):
        return self.Impl.GetId()

    def SetId(self, TCryptaId id):
        self.Impl.SetId(id)

    def Merge(self, TGraph other):
        self.Impl.Merge(move(other.Impl))

    def Clear(self):
        self.Impl.Clear()

    def __richcmp__(TGraph a, TGraph b, int op):
        if op == Py_EQ:
            return TGraphComparator.Equal(a.Impl, b.Impl)
        elif op == Py_NE:
            return not TGraphComparator.Equal(a.Impl, b.Impl)
        else:
            return False
