package ru.yandex.crypta.lab;

import java.util.List;

import ru.yandex.crypta.common.exception.NotFoundException;
import ru.yandex.crypta.lab.proto.Audience;


public interface AudienceService extends WithOptions<AudienceService> {

    Audience getLabAudienceById(String id) throws NotFoundException;

    List<Audience> getMyLabAudiences();

    Audience createAudience(Audience.Builder prototype);

    Audience setExternalId(String id, Long audienceId) throws NotFoundException;

    Audience updateState(String id, Audience.State state) throws NotFoundException;

    Audience modifyAudience(String id, String sourcePath, String sourceField) throws NotFoundException;

    Audience deleteAudience(String id) throws NotFoundException;

    Audience deleteLabAudience(String id) throws NotFoundException;

}

