package ru.yandex.crypta.lab;

import java.util.List;
import java.util.Optional;

import ru.yandex.crypta.lab.proto.Rule;
import ru.yandex.crypta.lab.proto.RuleCondition;
import ru.yandex.crypta.lab.rule_estimator.proto.RuleEstimateStats;


public interface ConstructorService extends WithOptions<ConstructorService> {

    List<Rule> getAllRules();

    Rule createRule(Rule.Builder prototype);

    Rule createExportRule(String exportId, Rule.Builder prototype);

    Rule getRule(String id);

    Rule updateRule(String id, Rule.Builder prototype);

    Rule deleteRule(String id);

    Rule deleteExportRule(String exportId);

    List<RuleCondition> getAllRulesConditions();

    List<RuleCondition> getAllRulesConditionsBySource(RuleCondition.Source source);

    RuleCondition putRuleCondition(String ruleId, RuleCondition.Source source, List<String> values);

    RuleCondition getRuleCondition(String ruleId, RuleCondition.Source source, RuleCondition.State state);

    List<RuleCondition> getRuleConditionBySource(String ruleId, RuleCondition.Source source);

    RuleCondition getRuleConditionByRevision(Long revision);

    RuleCondition approveRuleCondition(String ruleId, RuleCondition.Source source);

    RuleCondition deleteRuleCondition(String ruleId, RuleCondition.Source source, RuleCondition.State state);

    List<RuleCondition> deleteRuleConditionBySource(String ruleId, RuleCondition.Source source);

    Optional<RuleEstimateStats> getRuleConditionEstimateStatsByRevision(Long revision);

    Optional<RuleEstimateStats> getRuleEstimateStats(String ruleId);

    boolean updateRuleEstimateStats(String ruleId);
}
