package ru.yandex.crypta.lab;

import java.util.Objects;

import ru.yandex.crypta.lab.utils.SchemaField;
import ru.yandex.misc.lang.DefaultObject;

public class CustomIdentifier extends DefaultObject {

    private final String name;
    private final Identifier identifier;

    public CustomIdentifier(String name, Identifier identifier) {
        this.name = name;
        this.identifier = identifier;
    }

    public String getName() {
        return name;
    }

    public Identifier getIdentifier() {
        return identifier;
    }

    public boolean matches(SchemaField schemaField) {
        return Objects.equals(name, schemaField.getName());
    }
}
