package ru.yandex.crypta.lab;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.crypta.common.exception.Exceptions;

public class I18Utils {

    public static I18String string(String en, String ru) {
        return new I18String(en, ru);
    }

    public static String pack(I18String tuple) {
        try {
            return new ObjectMapper().writeValueAsString(tuple);
        } catch (JsonProcessingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static I18String unpack(String packed) {
        try {
            return new ObjectMapper().readValue(packed, I18String.class);
        } catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static class I18String {
        private String en;
        private String ru;

        private I18String() {
        }

        private I18String(String en, String ru) {
            this.en = en;
            this.ru = ru;
        }

        public String getEn() {
            return en;
        }

        public String getRu() {
            return ru;
        }
    }

}
