package ru.yandex.crypta.lab;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.databind.JsonNode;
import javafx.util.Pair;

import ru.yandex.crypta.audience.proto.TUserDataStats;
import ru.yandex.crypta.lab.proto.SocdemThreshold;
import ru.yandex.crypta.lab.proto.TSampleGroupID;
import ru.yandex.crypta.lab.proto.TSimpleSampleStats;
import ru.yandex.crypta.lab.proto.TSimpleSampleStatsWithInfo;
import ru.yandex.crypta.lab.proto.WholeView;
import ru.yandex.crypta.siberia.bin.custom_audience.common.proto.TCaRule;
import ru.yandex.crypta.siberia.bin.custom_audience.common.proto.TExtendedCaRule;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public interface LabService extends WithOptions<LabService> {

    void initialize();

    Map<String, String> getKeywordInfo(String id);

    Keyword updateKeywordInfo(Keyword keyword);

    WholeView getAll();

    JsonNode getDirectTaxonomy();

    Map<String, Map<String, Double>> getSocdemThresholds();

    SocdemThreshold updateSocdemThreshold(SocdemThreshold socdemThreshold);

    AudienceService audiences();

    ConstructorService constructor();

    SampleService samples();

    TrainingSampleService trainingSamples();

    Site2VecService site2vec();

    SegmentService segments();

    SegmentExportService segmentExports();

    ModelService models();

    Optional<TSimpleSampleStats> getStats(TSampleGroupID target);

    Optional<TSimpleSampleStats> getStats(TSampleGroupID target, TSampleGroupID base);

    Optional<TSimpleSampleStats> getStatsByExportId(TSampleGroupID target, String baseSegmentId);

    Optional<TSimpleSampleStatsWithInfo> getStatsFromSiberia(String userSetId);

    Optional<TSimpleSampleStatsWithInfo> getStatsFromSiberia(Pair<String, String> targetBaseIds);

    Optional<TSimpleSampleStatsWithInfo> getStatsFromSiberia(String userSetId, Optional<String> customGlobalStatsVersion);

    Optional<TSimpleSampleStatsWithInfo> getStatsFromSiberia(String userSetId, String login);

    String getUserSetIdByExportId(String exportId);

    Optional<TSimpleSampleStats> getCustomAudienceStats(TCaRule rule);

    Optional<TSimpleSampleStats> getCustomAudienceStats(TExtendedCaRule rule);

    TUserDataStats getGlobalStats();

    TSimpleSampleStats getSimpleSampleStats(TUserDataStats userDataStats);

    List<Map<String, String>> getSegmentsMetaForMediaservices();

    Optional<TSimpleSampleStats> getStatsFromYt(YPath path, String groupId, Optional<String> customGlobalStatsVersion);
}
