package ru.yandex.crypta.lab;

import java.util.List;

import ru.yandex.crypta.common.exception.NotFoundException;
import ru.yandex.crypta.lab.proto.Model;
import ru.yandex.crypta.lab.proto.Segment;
import ru.yandex.crypta.lab.proto.Thresholds;

public interface ModelService extends WithOptions<ModelService> {

    List<Model> getActive(String segmentId);

    Model link(Model model, Segment segment, Thresholds thresholds);

    Model unlink(Model model, Segment segment);

    List<Model> getAll();

    Model delete(String id) throws NotFoundException;

    Model put(byte[] data, Model.Builder prototype);

    List<Model> get(List<String> ids) throws NotFoundException;

    Model get(String id) throws NotFoundException;

    Model getByTag(String tag) throws NotFoundException;

    byte[] getFile(String id) throws NotFoundException;

    byte[] getFileByTag(String tag) throws NotFoundException;

    Model update(Model.Builder model);
}
