package ru.yandex.crypta.lab;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.crypta.audience.proto.TUserDataStats;
import ru.yandex.crypta.common.exception.NotFoundException;
import ru.yandex.crypta.lab.proto.AccessLevel;
import ru.yandex.crypta.lab.proto.ESampleViewState;
import ru.yandex.crypta.lab.proto.Sample;
import ru.yandex.crypta.lab.proto.Subsamples;
import ru.yandex.crypta.lab.proto.TMatchingOptions;
import ru.yandex.crypta.lab.proto.TSampleView;
import ru.yandex.crypta.lab.proto.TSampleViewOptions;
import ru.yandex.crypta.lab.siberia.RawResponse;
import ru.yandex.crypta.lib.proto.identifiers.TIds;
import ru.yandex.crypta.lib.schedulers.JobView;
import ru.yandex.crypta.siberia.proto.TDescribeIdsResponse;
import ru.yandex.crypta.siberia.proto.TStats;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public interface SampleService extends WithOptions<SampleService> {

    Sample getSample(String id) throws NotFoundException;

    Sample createSample(YPath path, String name, CustomIdentifier customIdentifier, String dateKey,
            String groupingKey, Long ttl, AccessLevel accessLevel, Integer maxGroupsCount);

    Sample setUserSetId(String id, String newSample);

    TSampleView createMatchingView(String id, TSampleViewOptions options) throws NotFoundException;

    TSampleView createCryptaIdStatisticsView(String id) throws NotFoundException;

    TSampleView createLookalikeView(String id, int outputCount, boolean useDates) throws NotFoundException;

    boolean canCreateView(String id, TMatchingOptions options) throws NotFoundException;

    Optional<TUserDataStats> getStats(String sampleId, String groupId) throws NotFoundException;

    Optional<TStats> getStatsFromSiberia(String userSetId);

    Optional<TStats> getStatsFromSiberia(String userSetId, String login);

    Sample updateSampleSource(String id, String source) throws NotFoundException;

    Sample updateSampleState(String id, String state) throws NotFoundException;

    String uploadSampleToSiberia(YPath path, String title, CustomIdentifier customIdentifier, Long ttl);

    Sample deleteSample(String id) throws NotFoundException;

    Sample describe(String id) throws NotFoundException;

    Sample pastDescribe(String id) throws NotFoundException;

    Sample learn(String id) throws NotFoundException;

    List<TSampleView> deleteOutdatedSampleViews();

    List<String> deleteOutdatedSamples();

    List<String> getGroups(String id);

    List<Sample> getAll();

    List<TSampleView> getViews(String id);

    TSampleView getView(String sampleId, String viewId);

    long getViewMinimalSize(String sampleId, String viewId);

    TSampleView deleteView(String sampleId, String viewId);

    TSampleView updateViewState(String sampleId, String viewId, ESampleViewState state);

    TSampleView updateViewError(String sampleId, String viewId, String error);

    List<JobView> getSampleJobs(String id);

    List<JsonNode> getSamplePagesFromYt(String sampleId, String viewId, long page, int pageSize);

    RawResponse getSampleFromSiberia(String userSetId, String lastUserId, long limit);

    RawResponse describeBySiberia(String userSetId);

    TDescribeIdsResponse describeIdsBySiberia(TIds ids);

    RawResponse createSiberiaSegment(String userSetId, String title, String rule);

    RawResponse removeSiberiaSegment(String userSetId, String segmentId);

    RawResponse getSegmentsFromSiberia(String userSetId, String lastSegmentId, long limit);

    RawResponse getSiberiaSegmentUsers(String userSetId, String segmentId, String lastUserId, long limit);

    RawResponse removeSiberiaUserSet(String userSetId);

    Subsamples getSubsamples(String sampleId);

    Subsamples createSubsamples(String sampleId, Map<String, String> ids);

    String getUserSetBySegmentGroupId(String baseSampleId, Optional<String> baseGroupId);
}
