package ru.yandex.crypta.lab;

import java.util.List;

import ru.yandex.crypta.lab.proto.Segment;
import ru.yandex.crypta.lab.utils.Taggable;

public interface SegmentExportService extends WithOptions<SegmentExportService>, Taggable {

    Segment.Export createExport(String segmentId, boolean exportCryptaId, Segment.Export.Builder export);

    Segment.Export getExport(String id);

    Segment.Export bindExport(String id, String segmentId);

    Segment.Export updateExport(String id, Segment.Export.Builder export);

    Segment.Export deleteExport(String id);

    Segment.Export updateExportState(String id, Segment.Export.State state);

    Segment.Export updateExportBigbCoverage(String id, Long value, Long timestamp);

    Segment.Export updateExportProfilesCoverage(String id, Long value, Long timestamp);

    Segment.Export putExportRuleId(String id, String ruleId);

    Segment.Export deleteExportRuleId(String id);

    Segment.Export putExportExpression(String id, List<String> expression);

    Segment.Export deleteExportExpression(String id);

    Segment.Export putLal(String id, String lal);

    Segment.Export deleteLal(String id);

    List<Segment.Export> getExportsWithRuleId();

    List<Segment.Export> getExportsNotExportedToBigB();

    Segment.Export disableExportToBigB(String exportId);

    Segment.Export enableExportToBigB(String exportId);

    Long getAvailableSegmentId(Long keywordId);

    List<Segment.Export> getDependantExports(String exportId);

    Segment.Export updateExportNextActivityCheckTs(String id, Long timestamp);

}

