package ru.yandex.crypta.lab;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.inject.Provider;
import javax.ws.rs.core.SecurityContext;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.crypta.common.exception.NotFoundException;
import ru.yandex.crypta.lab.proto.Segment;
import ru.yandex.crypta.lab.proto.SegmentAttributes;
import ru.yandex.crypta.lab.proto.SegmentConditions;
import ru.yandex.crypta.lab.proto.SegmentGroup;
import ru.yandex.crypta.lab.proto.SegmentIdPair;
import ru.yandex.crypta.lab.proto.TSimpleSampleStatsWithInfo;
import ru.yandex.crypta.lab.proto.Translations;
import ru.yandex.crypta.lab.utils.SegmentName;
import ru.yandex.crypta.lab.utils.SegmentNode;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public interface SegmentService extends WithOptions<SegmentService> {

    boolean allowedToEditSegment(String id, Provider<SecurityContext> context);

    SegmentGroup getGroup(String groupId);

    SegmentGroup getGroup(String groupId, boolean localized);

    List<SegmentGroup> getAllGroups();

    SegmentNode getGroupsTree();

    Segment get(String id) throws NotFoundException;

    Segment getNotLocalized(String id) throws NotFoundException;

    List<Segment> getAll();

    SegmentAttributes getByExportId(String exportId);

    List<SegmentAttributes> getSegmentsAttributes();

    List<SegmentAttributes> matchSearchItems(List<String> searchItems);

    List<SegmentAttributes> matchSegmentConditions(SegmentConditions conditions);

    Segment createSegment(String preferredId, Segment.Builder prototype);

    Segment createUserSegment(Segment.Builder prototype);

    Segment deleteSegment(String id);

    Segment setSegmentParent(String segmentId, String newGroupId);

    SegmentGroup setGroupParent(String groupId, String newParentGroupId);

    SegmentGroup createGroup(SegmentGroup.Builder prototype);

    SegmentGroup deleteGroup(String id);

    Segment updateName(String id, String value);

    Segment updateDescription(String id, String value);

    Segment updateNameAndDescription(String id, String name, String description);

    Segment updateNameKey(String id, String key);

    Segment updateDescriptionKey(String id, String key);

    Map<String, List<SegmentGroup>> getParentsPerSegment();

    Map<Long, Map<Long, Segment>> getExportsToSimpleSegments();

    void updatePriority(String id, Long priority);

    void addStakeholder(String id, String stakeholder);

    void deleteStakeholder(String id, String stakeholder);

    void addResponsible(String id, String responsible);

    void deleteResponsible(String id, String responsible);

    Optional<TSimpleSampleStatsWithInfo> getStats(String id);

    Optional<TSimpleSampleStatsWithInfo> getStats(String exportId, Optional<String> baseExportId, Optional<String> baseSampleId, Optional<String> baseGroupId);

    JsonNode getTranslations();

    void updateKeysFromTanker();

    Map<String, Translations> createSegmentKeysInTanker(String segmentId, String nameRu, String descriptionRu, boolean skipTranslation);

    Translations removeKeyAndTranslations(String key);

    JsonNode getTankerKeysInconsistency();

    Map<String, Translations> deleteSegmentKeysFromTanker(String segmentId);

    Translations getTranslationsFromTankerByKey(String tankerKey);

    Map<Long, SegmentName> getSegmentNamesWithExportId(Long keywordId);

    SegmentIdPair getSegmentPairBySegmentLabId(String segmentLabId);

    List<SegmentIdPair> updateSegmentIdsTable(YPath sourceTable);
}
