package ru.yandex.crypta.lab;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public interface Site2VecService {

    Vector getVectorByYandexuid(String yandexuid);

    Vector getVectorByHost(String host);

    List<Similarity> computePairwiseSimilarities(List<String> yandexuids, List<String> hosts);

    class Vector {

        private final float[] values;

        @JsonCreator
        public Vector(float[] values) {
            this.values = values;
        }

        @JsonValue
        public float[] getValues() {
            return values;
        }
    }

    class Similarity {

        private final String lhs;
        private final String rhs;
        private final float similarity;

        public Similarity(String lhs, String rhs, float similarity) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.similarity = similarity;
        }

        public String getLhs() {
            return lhs;
        }

        public String getRhs() {
            return rhs;
        }

        public float getSimilarity() {
            return similarity;
        }
    }
}
