package ru.yandex.crypta.lab;

import java.io.InputStream;
import java.util.List;

import ru.yandex.crypta.common.exception.NotFoundException;
import ru.yandex.crypta.lab.proto.AccessLevel;
import ru.yandex.crypta.lab.proto.ETrainableSegmentOriginType;
import ru.yandex.crypta.lab.proto.ETrainableSegmentTargetType;
import ru.yandex.crypta.lab.proto.TTrainableSegment;
import ru.yandex.crypta.lab.proto.TTrainingSample;
import ru.yandex.crypta.lab.proto.TrainableSegments;
import ru.yandex.crypta.lib.python.custom_ml.proto.ETrainingSampleState;
import ru.yandex.crypta.lib.python.custom_ml.proto.TIndustry;
import ru.yandex.crypta.lib.python.custom_ml.proto.TMetrics;
import ru.yandex.crypta.lib.python.custom_ml.proto.TTrainingError;

public interface TrainingSampleService extends WithOptions<TrainingSampleService> {

    TTrainingSample getSample(String id) throws NotFoundException;

    List<TTrainingSample> getAll();

    TTrainingSample createSample(String path, InputStream stream, String audienceId, String name, AccessLevel accessLevel,
                                 Long ttl, Long positiveSegmentSize, Long negativeSegmentSize,
                                 String modelName, String partner, String loginsToShare);

    TTrainableSegment addSegmentDescription(String sampleId, ETrainableSegmentTargetType targetType,
                    ETrainableSegmentOriginType originType, Integer rowsCount, String userSetId);

    TTrainableSegment addSegmentDescriptionFromTable(String sampleId, ETrainableSegmentTargetType targetType,
                                                     ETrainableSegmentOriginType originType);

    List<TTrainingSample> deleteOutdatedSamples();

    TTrainingSample deleteSample(String sampleId);

    TMetrics getSampleMetricsFromYt(String sampleId);

    TMetrics getMetrics(String sampleId) throws NotFoundException;

    TMetrics addSampleMetricsToDB(String sampleId);

    boolean IsMetricsReadyForSample(String sampleId);

    TrainableSegments getSegments(String sampleId);

    List<TTrainableSegment> getSegmentsDetails(String sampleId);

    void writeTrainingSampleMetrics(TMetrics metrics);

    void writeTrainingSampleError(TTrainingError trainingError);

    void updateSampleState(String id, ETrainingSampleState state);

    void addIndustry(TIndustry industry);

    List<TIndustry> getAllIndustries();
}
