package ru.yandex.crypta.lab.custom_audience;

import java.time.Duration;
import java.util.Optional;

import javax.inject.Inject;

import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.audience.proto.TUserDataStats;
import ru.yandex.crypta.lab.utils.GrpcRetries;
import ru.yandex.crypta.lib.proto.TCustomAudienceConfig;
import ru.yandex.crypta.siberia.bin.custom_audience.common.proto.TCaRule;
import ru.yandex.crypta.siberia.bin.custom_audience.common.proto.TExtendedCaRule;
import ru.yandex.crypta.siberia.bin.custom_audience.fast.grpc.TCustomAudienceServiceGrpc;
import ru.yandex.crypta.siberia.bin.custom_audience.fast.grpc.TCustomAudienceServiceGrpc.TCustomAudienceServiceBlockingStub;

public class CustomAudienceClient {
    private final TCustomAudienceServiceBlockingStub blockingStub;
    private static final Logger LOG = LoggerFactory.getLogger(CustomAudienceClient.class);

    @Inject
    public CustomAudienceClient(TCustomAudienceConfig config) {
        var channel = ManagedChannelBuilder.forAddress(config.getHost(), config.getPort())
                .defaultServiceConfig(
                        GrpcRetries.buildConfig(4D, Duration.ofMillis(50), Duration.ofSeconds(1), 2D)
                )
                .enableRetry()
                .maxInboundMessageSize(100 * 1000 * 1000)
                .usePlaintext()
                .build();
        blockingStub = TCustomAudienceServiceGrpc.newBlockingStub(channel);
    }

    public Optional<TUserDataStats> getStats(TCaRule rule) {
        try {
            return Optional.of(blockingStub.getStats(rule));
        } catch (StatusRuntimeException e) {
            LOG.warn("RPC failed: {}", e.getStatus());
            return Optional.empty();
        }
    }

    public Optional<TUserDataStats> getStatsByExtendedRule(TExtendedCaRule rule) {
        try {
            return Optional.of(blockingStub.getStatsByExtendedRule(rule));
        } catch (StatusRuntimeException e) {
            LOG.warn("RPC failed: {}", e.getStatus());
            return Optional.empty();
        }
    }
}
