package ru.yandex.crypta.lab.formatters;

public class AppFormatter implements RuleConditionFormatter {
    public static final AppFormatter instance = new AppFormatter();

    @Override
    public FormattedLine format(final String raw) {
        return raw.matches("[-a-zA-Z0-9._]+") ?
                FormattedLine.line(raw, raw) :
                FormattedLine.error(raw, "App id can only contain English letters, numbers, dots, hyphens and underscores");
    }
}
