package ru.yandex.crypta.lab.formatters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

import org.jetbrains.annotations.NotNull;

import ru.yandex.crypta.lib.word.rule.WordRuleParser;

public class ExpressionFormatter extends BooleanRuleFormatter {
    private final Function<Set<String>, Set<String>> getUnknownExports;
    private Set<String> exportIds;

    public ExpressionFormatter(Function<Set<String>, Set<String>> getUnknownExports) {
        this.getUnknownExports = getUnknownExports;
    }

    @Override
    protected ExpressionNode visitLemmaExpr(@NotNull WordRuleParser.LemmaExprContext ctx) {
        var exportId = ctx.getText();
        exportIds.add(exportId);
        return new ExpressionNode(exportId);
    }

    @Override
    public FormattedLine format(final String expression) {
        exportIds = new HashSet<>();

        try {
            var normalizedRule = getNormalizedRule(expression);
            var unknownExports = getUnknownExports.apply(exportIds);

            if (!unknownExports.isEmpty()) {
                return FormattedLine.error(expression, String.format("Unknown exports: %s", String.join(", ", unknownExports)));
            }

            return FormattedLine.line(expression, normalizedRule.toString(), new ArrayList<>(normalizedRule.getTags()));
        } catch (ParsingException e) {
            return FormattedLine.error(expression, e.getMessage());
        }
    }
}
