package ru.yandex.crypta.lab.formatters;

import java.util.List;
import java.util.Optional;

public class FormattedLine
{
    final public String rawLine;
    final public Optional<String> line;
    final public Optional<String> error;
    final public List<String> tags;

    public FormattedLine(String rawLine, String line, String error, List<String> tags) {
        this.rawLine = rawLine;
        this.line = Optional.ofNullable(line);
        this.error = Optional.ofNullable(error);
        this.tags = tags;
    }

    public static FormattedLine error(String rawLine, String error) {
        return new FormattedLine(rawLine, null, error, List.of());
    }

    public static FormattedLine line(String rawLine, String line, List<String> tags) {
        return new FormattedLine(rawLine, line, null, tags);
    }

    public static FormattedLine line(String rawLine, String line) {
        return new FormattedLine(rawLine, line, null, List.of());
    }

    public static FormattedLine line(String line) {
        return new FormattedLine(line, line, null, List.of());
    }

    public static FormattedLine line(String line, List<String> tags) {
        return new FormattedLine(line, line, null, tags);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof FormattedLine)) return false;

        FormattedLine other = (FormattedLine) o;
        return rawLine.equals(other.rawLine) && line.equals(other.line) && error.equals(other.error) && tags.containsAll(other.tags) && other.tags.containsAll(tags);
    }

    @Override
    public int hashCode() {
        if (line.isPresent()) {
            return line.hashCode();
        } else {
            return error.hashCode();
        }
    }

    @Override
    public String toString() {
        return String.format("FormattedLine{rawLine=%s, line=%s, error=%s, tags=%s}", rawLine, line, error, tags);
    }
};
