package ru.yandex.crypta.lab.formatters;

import com.google.common.base.Splitter;

public class IntWithCommentFormatter implements RuleConditionFormatter {
    public static final String COMMENT = "#";

    public static final IntWithCommentFormatter instance = new IntWithCommentFormatter();

    @Override
    public FormattedLine format(final String raw) {
        try {
            var value = Splitter.on(COMMENT).splitToList(raw).get(0).strip();
            Long.parseLong(value);
            return FormattedLine.line(raw, value);
        } catch (NumberFormatException e) {
            return FormattedLine.error(raw, "Not a number");
        }
    }
}
