package ru.yandex.crypta.lab.formatters;

import com.google.common.base.Splitter;

public class MetricaCounterFormatter implements RuleConditionFormatter {
    public static final String DELIMITER = ":";

    public static final MetricaCounterFormatter instance = new MetricaCounterFormatter();

    @Override
    public FormattedLine format(final String line) {
        try {
            var parts = Splitter.on(DELIMITER).splitToList(line);

            if (parts.size() > 2) {
                return FormattedLine.error(line, "Format is <counter_id>[:<goal_id>]");
            }

            for (var part : parts) {
                Long.parseLong(part);
            }

            return FormattedLine.line(line);
        } catch (NumberFormatException e) {
            return FormattedLine.error(line, "Ids must be numbers");
        }
    }
}
