package ru.yandex.crypta.lab.formatters;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import ru.yandex.crypta.lab.proto.FullValue;

public class RuleFormatUtils {
    private static final String DELIMITER = ";";

    public static List<FormattedLine> parseValues(RuleConditionFormatter ruleConditionFormatter, String serializedValues) {
        return serializedValues.isEmpty() ?
                List.of() :
                Arrays.stream(serializedValues.split(DELIMITER))
                        .map(ruleConditionFormatter::format)
                        .collect(Collectors.toList());
    }

    public static String serializeValues(Collection<String> values) {
        return String.join(DELIMITER, values);
    }

    public static List<FullValue> getFullValue(List<FormattedLine> values) {
        return IntStream.range(0, values.size())
                .mapToObj(i -> FullValue.newBuilder()
                        .setError(values.get(i).error.orElse((i >= 2000) ? "Too many lines (maximum is 2000)" : ""))
                        .addAllTags(values.get(i).tags)
                        .setRaw(values.get(i).rawLine)
                        .setNormalized(values.get(i).line.orElse(values.get(i).rawLine))
                        .build()
                ).collect(Collectors.toList());
    }

    public static List<String> formatValues(Collection<FormattedLine> values) {
        return values.stream()
                .filter(formatted -> formatted.line.isPresent())
                .map(formatted -> formatted.line.get())
                .distinct()
                .collect(Collectors.toList());
    }

    public static boolean hasErrors(List<FullValue> values) {
        return values.stream().anyMatch(full -> !"".equals(full.getError()));
    }
}
