package ru.yandex.crypta.lab.job;

import java.time.Duration;
import java.util.Map;

import org.quartz.JobExecutionContext;

import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.clients.sandbox.entity.CustomField;
import ru.yandex.crypta.clients.sandbox.entity.Description;
import ru.yandex.crypta.clients.sandbox.entity.TaskDraft;
import ru.yandex.crypta.common.exception.NotFoundException;


public abstract class AudienceBaseJob extends LabJob {
    public static final String AUDIENCE_ID = "audience_lab_id";
    public static final String LOGIN = "login";

    protected AudienceBaseJob(SandboxClient sandbox) {
        super(sandbox);
    }

    @Override
    protected void onSuccess(JobExecutionContext context) {
        try {
            onAudienceJobSuccess(context);
        } catch (NotFoundException exception) {
            LOG.error("Audience " + getArgument(context, AUDIENCE_ID) + " was not found in DB during onAudienceJobSuccess()", exception);
        }
    }

    @Override
    protected void onFailure(JobExecutionContext context) {
        try {
            onAudienceJobFailure(context);
        } catch (NotFoundException exception) {
            LOG.error("Audience " + getArgument(context, AUDIENCE_ID) + " was not found in DB during onAudienceJobFailure()", exception);
        }
    }

    protected abstract void onAudienceJobSuccess(JobExecutionContext context);

    protected abstract void onAudienceJobFailure(JobExecutionContext context);

    @Override
    protected int getInitialRetriesCount() {
        return 1;
    }

    @Override
    protected Duration checkAgainInterval() {
        return Duration.ofMinutes(1);
    }

    @Override
    protected String taskName() {
        return "crypta.lab.lib.audience." + taskCommand();
    }


    @Override
    protected TaskDraft taskDraft(JobExecutionContext context) {
        String audienceId = getArgument(context, AUDIENCE_ID);

        TaskDraft draft = defaultAugmentedTaskDraft(context);
        draft.addCustomField(new CustomField("task_args", taskArgs(context)));
        draft.addTag(tag(audienceId));
        draft.setDescription(new Description(taskCommand() + " " + audienceId));

        return draft;
    }

    protected abstract Map<String, String> taskArgs(JobExecutionContext context);
    protected abstract String taskCommand();
}
