package ru.yandex.crypta.lab.job;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

import org.quartz.JobExecutionContext;

import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.lab.proto.Audience;


public class AudienceDeleteJob extends AudienceBaseJob {
    public static final String SEGMENT_ID = "segment_id";

    @Inject
    public AudienceDeleteJob(SandboxClient sandbox) {
        super(sandbox);
    }

    @Override
    protected void onAudienceJobSuccess(JobExecutionContext context) {
        lab().audiences().updateState(getArgument(context, AUDIENCE_ID), Audience.State.DELETED);
    }

    @Override
    protected void onAudienceJobFailure(JobExecutionContext context) {
        lab().audiences().updateState(getArgument(context, AUDIENCE_ID), Audience.State.ERROR_DELETING);
    }

    @Override
    protected String taskCommand() {
        return "Delete";
    }

    @Override
    protected Map<String, String> taskArgs(JobExecutionContext context) {
        Map<String, String> args = new HashMap<>();
        args.put(LOGIN, getArgument(context, LOGIN));
        args.put(SEGMENT_ID, getArgument(context, SEGMENT_ID));
        return args;
    }
}
