package ru.yandex.crypta.lab.job;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

import org.quartz.JobExecutionContext;

import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.lab.proto.Audience;


public class AudienceModifyJob extends AudienceBaseJob {
    public static final String SEGMENT_ID = "segment_id";
    public static final String TABLE = "table";
    public static final String TABLE_FIELD = "table_field";

    @Inject
    public AudienceModifyJob(SandboxClient sandbox) {
        super(sandbox);
    }

    @Override
    protected String taskCommand() {
        return "Modify";
    }

    @Override
    protected void onAudienceJobSuccess(JobExecutionContext context) {
        lab().audiences().updateState(getArgument(context, AUDIENCE_ID), Audience.State.READY);
    }

    @Override
    protected void onAudienceJobFailure(JobExecutionContext context) {
        lab().audiences().updateState(getArgument(context, AUDIENCE_ID), Audience.State.ERROR_MODIFYING);
    }

    @Override
    protected Map<String, String> taskArgs(JobExecutionContext context) {
        Map<String, String> args = new HashMap<>();
        args.put(LOGIN, getArgument(context, LOGIN));
        args.put(SEGMENT_ID, getArgument(context, SEGMENT_ID));
        args.put(TABLE, getArgument(context, TABLE));
        args.put(TABLE_FIELD, getArgument(context, TABLE_FIELD));
        return args;
    }

}
