package ru.yandex.crypta.lab.job;

import org.quartz.Job;
import org.quartz.JobExecutionContext;

public abstract class CommonJob implements Job {

    protected String getArgument(JobExecutionContext context, String key) {
        return context.getJobDetail().getJobDataMap().getString(key);
    }

    protected boolean hasArgument(JobExecutionContext context, String key) {
        return context.getJobDetail().getJobDataMap().containsKey(key);
    }

    protected void putArgument(JobExecutionContext context, String key, Object value) {
        context.getJobDetail().getJobDataMap().put(key, value);
    }

}
