package ru.yandex.crypta.lab.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.lab.LabService;

@DisallowConcurrentExecution
public class DeleteOutdatedSamplesJob implements Job {
    private final LabService labService;

    private static final Logger LOG = LoggerFactory.getLogger(DeleteOutdatedSamplesJob.class);

    @Inject
    public DeleteOutdatedSamplesJob(LabService labService) {
        this.labService = labService;
    }

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            LOG.info("Deleting outdated sample views");
            labService.samples().deleteOutdatedSampleViews();
            LOG.info("Finished deleting outdated sample views");

            LOG.info("Deleting outdated samples");
            labService.samples().deleteOutdatedSamples();
            LOG.info("Finished deleting outdated samples");

            LOG.info("Deleting outdated training samples");
            labService.trainingSamples().deleteOutdatedSamples();
            LOG.info("Finished deleting outdated training samples");
        } catch (Throwable e) {
            LOG.error("Error in deleting samples");
            throw Exceptions.internal(e.getMessage());
        }
    }
}
