package ru.yandex.crypta.lab.job;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

import org.quartz.JobExecutionContext;

import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.clients.sandbox.entity.CustomField;
import ru.yandex.crypta.clients.sandbox.entity.Description;
import ru.yandex.crypta.clients.sandbox.entity.Tag;
import ru.yandex.crypta.clients.sandbox.entity.TaskDraft;

public class DescribeSubsamples extends LabJob {
    public static final String VIEW_ID = "src_view_id";
    public static final String MAX_GROUPS_COUNT = "max_groups_count";

    @Inject
    public DescribeSubsamples(SandboxClient sandbox) {
        super(sandbox);
    }

    @Override
    protected String taskName() {
        return "crypta.lab.lib.samples.samples.DescribeSubsamples";
    }

    @Override
    protected TaskDraft taskDraft(JobExecutionContext context) {
        String sampleId = getArgument(context, SAMPLE_ID);
        String viewId = getArgument(context, VIEW_ID);
        String maxGroupsCount = getArgument(context, MAX_GROUPS_COUNT);

        TaskDraft draft = defaultAugmentedTaskDraft(context);
        draft.addCustomField(new CustomField("task_args", taskArgs(context)));
        draft.addTag(new Tag(sampleId));
        draft.setDescription(
                new Description(
                        String.format("Describe in Siberia %s %s with maximum %s subsamples", sampleId, viewId, maxGroupsCount)
                )
        );

        return draft;
    }

    @Override
    protected int getInitialRetriesCount() {
        return 5;
    }

    @Override
    protected void onFailure(JobExecutionContext context) {
        super.onFailure(context);
    }

    private Map<String, String> taskArgs(JobExecutionContext context) {
        Map<String, String> args = new HashMap<>();
        args.put(VIEW_ID, getArgument(context, VIEW_ID));
        args.put(SAMPLE_ID, getArgument(context, SAMPLE_ID));
        args.put(MAX_GROUPS_COUNT, getArgument(context, MAX_GROUPS_COUNT));

        return args;
    }
}
