package ru.yandex.crypta.lab.job;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

import org.quartz.JobExecutionContext;

import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.clients.sandbox.entity.CustomField;
import ru.yandex.crypta.clients.sandbox.entity.Description;
import ru.yandex.crypta.clients.sandbox.entity.Tag;
import ru.yandex.crypta.clients.sandbox.entity.TaskDraft;

public class LearnSampleJob extends LabJob {

    @Inject
    public LearnSampleJob(SandboxClient sandbox) {
        super(sandbox);
    }

    @Override
    protected String taskName() {
        return "crypta.lab.lib.learn.Learn";
    }

    @Override
    protected TaskDraft taskDraft(JobExecutionContext context) {
        String sampleId = getSampleId(context);

        TaskDraft draft = defaultAugmentedTaskDraft(context);
        draft.addCustomField(new CustomField("task_args", taskArgs(context)));
        draft.addTag(new Tag(sampleId));
        draft.setDescription(new Description(String.format("Learn %s", sampleId)));

        return draft;
    }

    private String getSampleId(JobExecutionContext context) {
        return getArgument(context, SAMPLE_ID);
    }

    @Override
    protected int getInitialRetriesCount() {
        return 1;
    }

    private Map<String, String> taskArgs(JobExecutionContext context) {
        Map<String, String> args = new HashMap<>();
        args.put(SAMPLE_ID, getSampleId(context));
        return args;
    }

}
