package ru.yandex.crypta.lab.job;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

import org.quartz.JobExecutionContext;

import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.clients.sandbox.entity.CustomField;
import ru.yandex.crypta.clients.sandbox.entity.Description;
import ru.yandex.crypta.clients.sandbox.entity.TaskDraft;

public class MatchSampleJob extends LabJob {

    public static final String SRC_VIEW = "src_view";
    public static final String DST_VIEW = "dst_view";

    @Inject
    public MatchSampleJob(SandboxClient sandbox) {
        super(sandbox);
    }

    @Override
    protected String taskName() {
        return "crypta.lab.lib.match.Match";
    }

    @Override
    protected TaskDraft taskDraft(JobExecutionContext context) {
        String sampleId = getArgument(context, SAMPLE_ID);

        TaskDraft draft = defaultAugmentedTaskDraft(context);
        draft.addCustomField(new CustomField("task_args", taskArgs(context)));
        draft.addTag(tag(sampleId));
        draft.addTag(tag(getArgument(context, DST_VIEW)));
        draft.setDescription(new Description("Match " + sampleId));

        return draft;
    }

    private Map<String, String> taskArgs(JobExecutionContext context) {
        Map<String, String> args = new HashMap<>();
        args.put(SAMPLE_ID, getArgument(context, SAMPLE_ID));
        args.put(SRC_VIEW, getArgument(context, SRC_VIEW));
        args.put(DST_VIEW, getArgument(context, DST_VIEW));
        return args;
    }

}
