package ru.yandex.crypta.lab.job;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

import org.quartz.JobExecutionContext;

import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.clients.sandbox.entity.CustomField;
import ru.yandex.crypta.clients.sandbox.entity.Description;
import ru.yandex.crypta.clients.sandbox.entity.Tag;
import ru.yandex.crypta.clients.sandbox.entity.TaskDraft;
import ru.yandex.crypta.lab.proto.ESampleViewState;

public class PastDescribeSampleJob extends LabJob {
    public static final String VIEW_ID = "view_id";

    @Inject
    public PastDescribeSampleJob(SandboxClient sandbox) {
        super(sandbox);
    }

    @Override
    protected String taskName() {
        return "crypta.lab.lib.describe.PastDescribe";
    }

    @Override
    protected TaskDraft taskDraft(JobExecutionContext context) {
        String sampleId = getArgument(context, SAMPLE_ID);
        String viewId = getArgument(context, VIEW_ID);

        TaskDraft draft = defaultAugmentedTaskDraft(context);
        draft.addCustomField(new CustomField("task_args", taskArgs(context)));
        draft.addTag(new Tag(sampleId));
        draft.setDescription(new Description(String.format("Past describe %s / %s", sampleId, viewId)));

        return draft;
    }

    @Override
    protected int getInitialRetriesCount() {
        return 5;
    }

    @Override
    protected void onFailure(JobExecutionContext context) {
        super.onFailure(context);

        lab().samples().updateViewState(
                getArgument(context, SAMPLE_ID),
                getArgument(context, VIEW_ID),
                ESampleViewState.ERROR
        );
    }

    private Map<String, String> taskArgs(JobExecutionContext context) {
        Map<String, String> args = new HashMap<>();
        args.put(SAMPLE_ID, getArgument(context, SAMPLE_ID));
        args.put(VIEW_ID, getArgument(context, VIEW_ID));
        return args;
    }

}
