package ru.yandex.crypta.lab.job;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

import org.quartz.JobExecutionContext;

import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.clients.sandbox.entity.CustomField;
import ru.yandex.crypta.clients.sandbox.entity.Description;
import ru.yandex.crypta.clients.sandbox.entity.Notification;
import ru.yandex.crypta.clients.sandbox.entity.Owner;
import ru.yandex.crypta.clients.sandbox.entity.Priority;
import ru.yandex.crypta.clients.sandbox.entity.Tag;
import ru.yandex.crypta.clients.sandbox.entity.TaskDraft;
import ru.yandex.crypta.clients.sandbox.entity.Type;

public class UploadSampleToSiberiaJob extends SandboxJob {
    public static final String PATH = "path";
    public static final String USER_SET_ID = "user_set_id";
    public static final String LOGIN = "login";
    public static final String ID_FIELD = "id_field";
    public static final String ID_TYPE = "id_type";
    public static final String SAMPLE_ID = "sample_id";

    @Inject
    public UploadSampleToSiberiaJob(SandboxClient sandbox) {
        super(sandbox);
    }

    @Override
    protected int getInitialRetriesCount() {
        return 2;
    }

    @Override
    protected TaskDraft taskDraft(JobExecutionContext context) {
        String sampleId = getArgument(context, SAMPLE_ID);
        String path = getArgument(context, PATH);
        String userSetId = getArgument(context, USER_SET_ID);
        String login = getArgument(context, LOGIN);
        String environment = getEnvironment(context);

        Map<String, String> fieldsIdTypes = new HashMap<>();
        fieldsIdTypes.put(getArgument(context, ID_FIELD), getArgument(context, ID_TYPE));

        TaskDraft draft = createTaskDraft();
        draft.setType(new Type("CRYPTA_SIBERIA_UPLOAD_USERS_TASK"));
        draft.setOwner(new Owner("CRYPTA"));
        draft.setPriority(new Priority("SERVICE", "NORMAL"));
        draft.setKillTimeout(Duration.ofHours(9).getSeconds());

        draft.addCustomField(new CustomField("environment", environment));
        draft.addCustomField(new CustomField("login", login));
        draft.addCustomField(new CustomField("user_set_id", userSetId));
        draft.addCustomField(new CustomField("src_table", path));
        draft.addCustomField(new CustomField("fields_id_types", fieldsIdTypes));

        draft.addTag(new Tag(sampleId));
        draft.addTag(new Tag("SIBERIA-USER-SET-" + userSetId));

        draft.setDescription(new Description(String.format("Upload '%s' to user set '%s'", path, userSetId)));
        draft.addNotification(new Notification("email")
                .addRecipient("crypta-siberia@yandex-team.ru")
                .addStatus("BREAK"));
        return draft;
    }
}
