package ru.yandex.crypta.lab.migrations;

import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.jooq.DSLContext;
import org.jooq.Query;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.impl.DSL;

import ru.yandex.crypta.clients.pgaas.PostgresClient;
import ru.yandex.crypta.common.ws.auth.ServiceSecurityContext;
import ru.yandex.crypta.lab.Identifier;
import ru.yandex.crypta.lab.proto.ESampleViewState;
import ru.yandex.crypta.lab.proto.Sample;
import ru.yandex.crypta.lab.proto.TSampleView;
import ru.yandex.crypta.lab.tables.SampleViewsTable;
import ru.yandex.crypta.lab.tables.SamplesTable;

@SuppressWarnings({"TypeName"})
public class R__Restore_source_sample_views extends BaseJavaMigration {

    public static final String SOURCE = "source";

    @Override
    public Integer getChecksum() {
        return 2;
    }

    @Override
    public void migrate(Context context) throws Exception {
        var connection = context.getConfiguration().getDataSource().getConnection();
        DSLContext dsl = DSL.using(connection);

        ServiceSecurityContext securityContext = new ServiceSecurityContext();
        SamplesTable samplesTable =
                new SamplesTable(PostgresClient.wrap(connection), securityContext);
        SampleViewsTable sampleViewsTable =
                new SampleViewsTable(PostgresClient.wrap(connection), securityContext);

        Select<Record1<String>> havingSources =
                dsl.selectDistinct(SampleViewsTable.SAMPLE_ID)
                        .from(SampleViewsTable.TABLE)
                        .where(SampleViewsTable.ID.equal(SOURCE));
        Result<Record1<String>> brokenSamples = dsl.select(SamplesTable.ID)
                .from(SamplesTable.TABLE)
                .where(SamplesTable.ID.notIn(havingSources))
                .fetch();
        brokenSamples.forEach(
                sampleRecord -> {
                    String sampleId = sampleRecord.value1();
                    Sample sample = samplesTable.selectByIdQuery(sampleId).fetchOneInto(Sample.class);

                    TSampleView.Builder view = TSampleView.newBuilder()
                            .setPath("//unknown")
                            .setState(ESampleViewState.READY)
                            .setID(SOURCE)
                            .setSampleID(sampleId);

                    Identifier identifier = Identifier.byName(sample.getIdName());

                    view.getOptionsBuilder()
                            .getMatchingBuilder()
                            .setIdType(identifier.getLabType())
                            .setKey(sample.getIdKey())
                            .setHashingMethod(identifier.getHashingMethod())
                            .setIncludeOriginal(true);

                    Query query = sampleViewsTable.insertOrUpdateQuery(view.build());
                    query.execute();
                }
        );
    }
}
