package ru.yandex.crypta.lab.siberia;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface SiberiaApi {

    @DELETE("/user_sets/remove")
    Call<ResponseBody> deleteUserSet(
            @Query("user_set_id") String userSetId
    );

    @GET("/user_sets/get_stats")
    Call<ResponseBody> getUserSetStats(
            @Query("user_set_id") String userSetId
    );

    @POST("/user_sets/describe")
    Call<ResponseBody> describeUserSet(
            @Query("user_set_id") String userSetId
    );

    @POST("/user_sets/describe_ids")
    Call<ResponseBody> describeIds(
            @Body RequestBody body,
            @Query("mode") String mode,
            @Query("experiment") String experiment
    );

    @GET("/users/search")
    Call<ResponseBody> getUsers(
            @Query("user_set_id") String userSetId,
            @Query("limit") Long limit,
            @Query("last_user_id") String lastUserId
    );

    @POST("/segments/make")
    Call<ResponseBody> createSegment(
            @Query("user_set_id") String userSetId,
            @Query("title") String title,
            @Query("rule") String rule
    );

    @GET("/segments/search")
    Call<ResponseBody> getSegments(
            @Query("user_set_id") String userSetId,
            @Query("limit") Long limit,
            @Query("last_segment_id") String lastSegmentId
    );

    @GET("/segments/list_users")
    Call<ResponseBody> getSegmentUsers(
            @Query("user_set_id") String userSetId,
            @Query("segment_id") String segmentId,
            @Query("limit") Long limit,
            @Query("last_user_id") String lastUserId
    );

    @POST("/segments/remove")
    Call<ResponseBody> deleteSegment(
            @Query("user_set_id") String userSetId,
            @Body RequestBody segmentId
    );

    @POST("user_sets/add")
    Call<ResponseBody> createUserSet(
            @Query("title") String title,
            @Query("ttl") Long ttl
    );
}
