package ru.yandex.crypta.lab.tables;

import javax.ws.rs.core.SecurityContext;

import org.jooq.Condition;
import org.jooq.impl.DSL;

import ru.yandex.crypta.idm.Roles;


public class AudiencesAcl {

    public static Condition isOf(SecurityContext securityContext) {
        return AudiencesTable.AUTHOR.eq(securityContext.getUserPrincipal().getName());
    }

    public static Condition isAccessibleBy(SecurityContext securityContext) {
        return isOf(securityContext).or(isAdmin(securityContext));
    }

    public static Condition isModifiableBy(SecurityContext securityContext) {
        return isOf(securityContext).or(isAdmin(securityContext));
    }

    private static Condition isAdmin(SecurityContext securityContext) {
        return DSL.value(securityContext.isUserInRole(Roles.ADMIN) || securityContext.isUserInRole(Roles.Lab.ADMIN))
                .isTrue();
    }

}
