package ru.yandex.crypta.lab.tables;

import org.jooq.Configuration;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.impl.DSL;

import ru.yandex.crypta.common.data.GenericTable;

public class ResponsiblesTable extends GenericTable<String> {

    public static final Table<Record> TABLE = DSL.table("api_responsibles");
    public static final Field<String> ID = DSL.field(DSL.name(TABLE.getName(), "id"), String.class);
    public static final Field<String> SEGMENT_ID = DSL.field(DSL.name(TABLE.getName(), "segment_id"), String.class);
    public static final Field<Long> CREATED = DSL.field(DSL.name(TABLE.getName(), "created"), Long.class);
    public static final Field<Long> MODIFIED = DSL.field(DSL.name(TABLE.getName(), "modified"), Long.class);

    public ResponsiblesTable(Configuration configuration) {
        super(configuration, String.class);
    }

    @Override
    protected String read(Record record) {
        return record.get(ID);
    }

    public SelectConditionStep<Record> selectBySegmentIdQuery(String id) {
        return dsl.selectFrom(TABLE).where(SEGMENT_ID.eq(id));
    }

    public SelectConditionStep<Record> selectBySegmentIdAndResponsibleQuery(String segmentId, String responsible) {
        return dsl.selectFrom(TABLE).where(SEGMENT_ID.eq(segmentId).and(ID.eq(responsible)));
    }

    public DeleteConditionStep<Record> deleteBySegmentIdAndResponsibleQuery(String segmentId, String responsible) {
        return dsl.deleteFrom(TABLE).where(SEGMENT_ID.eq(segmentId)).and(ID.eq(responsible));
    }

    public DeleteConditionStep<Record> deleteBySegmentIdQuery(String id) {
        return dsl.deleteFrom(TABLE).where(SEGMENT_ID.eq(id));
    }

    private Query genericInsertQuery(Table<Record> table, String responsible, String segmentId,
            long created, long modified)
    {
        return dsl.insertInto(table)
                .set(ID, responsible)
                .set(SEGMENT_ID, segmentId)
                .set(CREATED, created)
                .set(MODIFIED, modified);
    }

    public Query insertQuery(String responsible, String segmentId,
            long created, long modified)
    {
        return genericInsertQuery(TABLE, responsible, segmentId, created, modified);
    }

    @Override
    public Select<Record> selectQuery() {
        return dsl.selectFrom(TABLE);
    }
}
