package ru.yandex.crypta.lab.tables;

import javax.ws.rs.core.SecurityContext;

import org.jooq.Condition;
import org.jooq.impl.DSL;

import ru.yandex.crypta.idm.Roles;


public class SegmentsAcl {

    public static Condition isAuthor(SecurityContext securityContext) {
        return SegmentsTable.AUTHOR.eq(securityContext.getUserPrincipal().getName());
    }

    public static Condition isResponsible(SecurityContext securityContext) {
        return ResponsiblesTable.ID.eq(securityContext.getUserPrincipal().getName() + "@yandex-team.ru");
    }

    public static Condition isOf(SecurityContext securityContext) {
        return isAuthor(securityContext).or(isResponsible(securityContext));
    }

    public static Condition isModifiableBy(SecurityContext securityContext) {
        return isOf(securityContext).or(isAdmin(securityContext));
    }

    private static Condition isAdmin(SecurityContext securityContext) {
        return DSL.value(securityContext.isUserInRole(Roles.ADMIN) || securityContext.isUserInRole(Roles.Lab.ADMIN))
                .isTrue();
    }

}
